<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ConcentFormData extends Model
{
    use HasFactory;
    protected $table = 'concent_form_data';
    protected $primaryKey = 'id_concent_form_data';

    protected $fillable = [
        'concent_form_id',
        'customer_id',
        'customer_name',
        'customer_email',
        'customer_cell',
        'customer_area',
        'customer_signature',
        'consultant_name',
        'consultant_signature',
        'concent_data',
        'concent_date',
        'staff_id',
        'visit_id',
        'form_title',
        'event_date',
        'visit_date',
        'updated_at',
        'created_at',
    ];

    public function concent_forms()
    {
        return $this->belongsTo(ConcentForms::class, 'concent_form_id', 'id_concent_forms');
    } 

    public function customer()
    {
        return $this->belongsTo(Customers::class, 'customer_id', 'id_customer');
    }

    public function staff()
    {
        return $this->belongsTo(Staff::class, 'staff_id', 'id_staff');
    }   

    public function visit()
    {
        return $this->belongsTo(CustomerVisits::class, 'visit_id', 'id_visit');
    }

}
