<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ConcentForms extends Model
{
    use HasFactory;
    protected $table = 'concent_forms';
    protected $primaryKey = 'id_concent_forms';

    protected $fillable = [
        'category_id',
        'concent_form',
        'form_structure',
        'created_on',
        'form_status',
    ];

    public function concent_category()
    {
        return $this->belongsTo(ConcentCategory::class, 'category_id', 'id_concent_category');
    } 

}
