<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class Coupon extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'coupons'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_coupons';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'coupon_category_id',    
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];


    public function coupon_category()
    {
        return $this->belongsTo(CouponCategory::class, 'coupon_category_id', 'id_coupon_category');
    }

   

}
