<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class CouponCategory extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'coupon_category'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_coupon_category';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'coupon_category',    
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];


    public function business()
    {
        return $this->belongsTo(Business::class, 'business_id', 'id_business');
    }

   

}
