<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class CouponServices extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'coupon_services'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_coupon_services';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'coupon_category_id',    
        'service_id',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];


    public function coupon_category()
    {
        return $this->belongsTo(Coupon::class, 'coupon_category_id', 'id_coupon_category');
    }

   

}
