<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class CustomerOrders extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'customer_orders'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_customer_order';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $guarded = ['id_customer_order'];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];


    public function business()
    {
         return $this->belongsTo(Business::class, 'business_id', 'id_business');
    }


    public function customers()
    {
         return $this->belongsTo(Customers::class, 'customer_id', 'id_customer');
    }

}
