<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class CustomerVisits extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'customer_visits'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_customer_visits';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'visit_date',
        'business_id',
        'customer_id',
        'visit_color',
        'customer_visit_date',
        'visit_status',
        'reminder_sms',
        'reminder_call',
        'reminder_email',
        'reminder_stricttime',
        'visit_color_type',
        'advance_comment',
        'cancelreason',
        'created_by',
        'canceled_by',
        'canceled_on',
        'inservice',
        'inservice_time',
        'referring_staff',
        'invoice_seq',
        'discount',
        'discount_reason',
        'program_enrolled_service_id',
        'group_id',
        'group_visit_id',
        'created_on',
        'customer_event_date',
        'visit_extra',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];


    public function business()
    {
        return $this->belongsTo(Business::class, 'business_id', 'id_business'); // assuming PK of business table is `id_business`
    }

    public function customer()
    {
        return $this->belongsTo(Customers::class, 'customer_id', 'id_customers'); // assuming PK of business table is `id_customers`
    }
}
