<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class Customers extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'customers'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_customers';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'business_id',
        'customer_name',
        'customer_email',
        'password',
        'customer_cell',
        'customer_address',
        'customer_area',
        'customer_phone1',
        'customer_phone2',
        'customer_image',
        'customer_birthday',
        'customer_anniversary',
        'customer_birthmonth',
        'customer_allergies',
        'customer_alert',
        'customer_type',
        'profession',
        'loyalty_points',
        'customer_careof',
        'created_on',
        'customer_gender',
        'customer_card',
        'customer_advance',
        'emergency_contact_person',
        'emergency_contact_number',
        'age',
        'height',
        'bmi',
        'fcm_id',
        'pin_code',
        'is_verified',
        'created_by',
        'referencing_staff',
        'father_profession',
        'mother_profession',
        'father_name',
        'father_cell',
        'mother_name',
        'mother_cell',
        'allowed_balance',
        'weight',
        'country_code',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];


    public function business()
    {
        return $this->belongsTo(Business::class, 'business_id', 'id_business'); // assuming PK of business table is `id_business`
    }

}
