<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DeductionPolicy extends Model
{
    use HasFactory;

    protected $table = 'deduction_policy'; 
    protected $primaryKey = 'id_deduction_policy';
    public $timestamps = false;
    protected $fillable = [
        'business_id',
        'deduction_policy',
        'deduction_days_absent',
        'deduction_days_late',
        'total_late_allowed',
        'total_absents_allowed',
        'created_at',
        'update_at'
    ];

    protected $hidden = [];
    protected $casts = [
        'deduction_days_absent' => 'decimal:2',
        'deduction_days_late' => 'decimal:2',
        'total_late_allowed' => 'integer',
        'total_absents_allowed' => 'integer'
    ];

    public function business()
    {
        return $this->belongsTo(Business::class, 'business_id', 'id_business');
    }

    public function staff()
    {
        return $this->hasMany(Staff::class, 'deduction_policy', 'id_deduction_policy');
    }
}