<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class Department extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'service_department'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_service_department';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'id_service_department',
        'service_department',
        'business_id',
        'department_status',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];


    public function business()
    {
         return $this->belongsTo(Business::class, 'business_id', 'id_business');
    } 

}
