<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class Dispatch extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'dispatch_notes'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_dispatch_note';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
       'business_id',
        'product_id',
        'dispatch_to_staff',
        'dispatch_qty',
        'unit_type',
        'measure_unit',
        'dispatch_measure',
        'dispatch_date',
        'created_by',
        'status',
        'batch',
        'batch_id',
        'dispatch_comment',
        'visit_id',
        'dispatch_created_on',
        'visit_service_id',
        'request_id',
        'order_id',
        'cancelled_by',
        'cancelled_on',
        'adjustment_note_id',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];


    public function business()
    {
        return $this->belongsTo(Business::class, 'business_id', 'id_business'); 
    }
   
}
