<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class DispatchRequest extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'dispatch_request'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_dispatch_request';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
       'dispatch_request_date',
        'customer_visit_id',
        'customer_id',
        'service_id',
        'visit_service_id',
        'visit_service_staff_id',
        'created_on',
        'created_by',
        'dispatch_request_status',
        'cancelled_by',
        'cancelled_on',
        'product_id',
        'product_name',
        'dispatch_note_id',
        'product_qty',
        'product_unit',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];


    public function business()
    {
        return $this->belongsTo(Business::class, 'business_id', 'id_business'); 
    }

    public function customer_visit()
    {
        return $this->belongsTo(CustomerVisits::class, 'customer_visit_id', 'id_customer_visits'); 
    }

    public function customer()
    {
        return $this->belongsTo(Customers::class, 'customer_id', 'id_customers'); 
    }

    public function service()
    {
        return $this->belongsTo(Services::class, 'service_id', 'id_business_services'); 
    }

    public function visit_service()
    {
        return $this->belongsTo(VisitServices::class, 'visit_service_id', 'id_visit_services'); 
    }

    public function dispatch_note()
    {
        return $this->belongsTo(DispatchNote::class, 'dispatch_note_id', 'id_dispatch_notes'); 
    }

    public function product()
    {
        return $this->belongsTo(Products::class, 'product_id', 'id_business_products'); 
    }
   
}
