<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class FaceRecognitionDeviceStaff extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'face_recognition_device_staff'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_face_recognition_device_staff';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'device_id',
        'staff_id',
        'device_staff_id',
        'created_on',
        'created_on',
        'created_by',
        's_name',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];


    public function face_recognition_device()
    {
         return $this->belongsToMany(FaceRecognitionDevices::class, 'device_id', 'id_face_recognition_devices');
    }

    public function staff()
    {
         return $this->belongsToMany(Staff::class, 'staff_id', 'id_staff');
    }

}
