<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Feedback extends Model
{
    use HasFactory;
    protected $table = 'feedback';
    protected $primaryKey = 'id_feedback';

    protected $fillable = [
        'customer_id',
        'invoice_id',
        'visit_id',
        'business_id',
        'created_on',
        'qos',
        'atmosphere',
        'experience',
        'valueformoney',
        'recommendable',
        'comment',
        'feedback_type',
        'customer_signature',
        'consultant_signature'
    ];

    public function customer()
    {
        return $this->belongsTo(Customers::class, 'customer_id', 'id_customers');
    }

    public function invoice()
    {
        return $this->belongsTo(Invoice::class, 'invoice_id', 'id_invoices');
    }

    public function visit()
    {
        return $this->belongsTo(CustomerVisits::class, 'visit_id', 'id_visits');
    }

    
}
