<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class Floor extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'business_floors'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_business_floors';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [

        'business_id',
        'floor_name',
        'floor_workstations',
        'floormanager_id',
        'floormanager_name',
        'created_on',
        'created_by',
        'floor_status'

    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];


    public function business()
    {
         return $this->belongsTo(Business::class, 'business_id', 'id_business');
    }

    public function staff()
    {
        return $this->hasMany(Staff::class, 'deduction_policy', 'id_deduction_policy');
    }
}
