<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class Franchise extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'franchises'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_franchises';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [

        'franchise_name',
        'franchise_address',
        'franchise_contact',
        'franchise_ntn',
        'franchise_owner',
        'franchise_office_phone',
        'franchise_email',
        'business_id',
        'created_by',
        'created_on',
        'franchise_discount',
        'franchise_limit',
        'franchise_status',

    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];


    public function business()
    {
         return $this->belongsTo(Business::class, 'business_id', 'id_business');
    }

}
