<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FranchiseOrder extends Model
{
    use HasFactory;

    protected $table = 'franchise_orders';
    protected $primaryKey = 'id_franchise_orders';

    protected $fillable = [
        'business_id',
        'franchise_id',
        'franchise_name',
        'franchise_ntn',
        'franchise_order_extra',
        'order_date',
        'order_status',
        'created_by',
        'created_on',
        'franchise_order_value',
        'franchise_order_discount',
        'invoice_discount',
        'invoice_discount_perc',
        'invoice_other_charges',
        'invoice_gross_total',
        'invoice_sales_tax',
        'invoice_sales_tax_perc',
        'invoice_total_receivable',
        'invoice_remarks',
        'invoice_number',
        'invoice_date',
        'cancelled_by',
        'cancelled_on',
        'product_discount',
        'product_tax',
    ];

    // Relation - One Order Has Many Products
    public function products()
    {
        return $this->hasMany(FranchiseOrderProduct::class, 'franchise_order_id', 'id_franchise_orders');
    }
}
