<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FranchiseOrderProduct extends Model
{
    use HasFactory;

    protected $table = 'franchise_order_products';
    protected $primaryKey = 'id_franchise_order_products';

    protected $fillable = [
        'business_id',
        'franchise_order_id',
        'product_id',
        'product_name',
        'product_detail',
        'category',
        'qty',
        'staff_id',
        'staff_name',
        'channel',
        'stockfrom',
        'batch',
        'batch_id',
        'unit_price',
        'unit_discount',
        'discounted_price',
        'order_month',
        'order_year',
        'product_tax',
    ];

    // Relation - Product Belongs To Order
    public function order()
    {
        return $this->belongsTo(FranchiseOrder::class, 'franchise_order_id', 'id_franchise_orders');
    }
}
