<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class GoodsReceivedNote extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'goods_received_note'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'grn_id'; // <-- this tells Laravel to use the correct primary key


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
       'business_id',
       'purchase_order_id',
       'grn_number',
       'grn_created_date',
       'grn_vendor_name',
       'created_by',
       'grn_comment',

    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];

    public function business()
    {
         return $this->belongsTo(Business::class, 'business_id', 'id_business');
    }

    public function purchaseOrder()
    {
         return $this->belongsTo(PurchaseOrder::class, 'purchase_order_id', 'idpurchase_order');
    }

}