<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class GoodsReceivedNoteDetails extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'grn_details'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'grn_detail_id'; // <-- this tells Laravel to use the correct primary key


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
          'grn_id',
          'grn_brand_id',
          'grn_product_id',
          'grn_brand_name',
          'grn_product_name',
          'grn_sku',
          'grn_qty_received',
          'grn_qty_instock',
          'grn_qty_inhouse',
          'grn_unit_price',
          'grn_unit_discount',
          'grn_batch_number',
          'grn_batch_id'

    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];

    public function goods_received_note()
    {
         return $this->belongsTo(GoodsReceivedNote::class, 'grn_id', 'grn_id');
    }

    public function product()
    {
         return $this->belongsTo(Product::class, 'grn_product_id', 'id_business_products');
    }

    public function brand()
    {
         return $this->belongsTo(Brand::class, 'grn_brand_id', 'id_business_brands');
    }

    public function business()
    {
         return $this->belongsTo(ProductBatch::class, 'grn_batch_id', 'id_batch');
    }

}