<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class Gtn extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'gtn'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_gtn';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
       'gtn_number',
        'gtn_date',
        'created_by',
        'created_on',
        'business_id',
        'comments',
        'to_store',

    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];

    public function business()
    {
         return $this->belongsTo(Business::class, 'business_id', 'id_business');
    }

    public function transfer_notes()
    {
         return $this->hasMany(TransferNotes::class, 'id_gtn', 'id_gtn');
    }

}