<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Holiday extends Model
{
    protected $table = 'holidays';
    protected $primaryKey = 'id_holidays';
    
    protected $fillable = [
        'holiday_date',
        'holiday_reason',
        'holiday_day',
        'business_id',
        'created_by'
    ];
    
    protected $casts = [
        'holiday_date' => 'date:Y-m-d', // Fixed: Format as Y-m-d without time
    ];
    
    public $timestamps = false; 
    
    /**
     * Get the formatted holiday date (always Y-m-d)
     */
    public function getHolidayDateAttribute($value)
    {
        if (!$value) {
            return null;
        }
        
        // If it's already a Carbon instance, format it
        if ($value instanceof \Carbon\Carbon) {
            return $value->format('Y-m-d');
        }
        
        // If it's a string, parse and format it
        return date('Y-m-d', strtotime($value));
    }
    
    public function business()
    {
        return $this->belongsTo(Business::class, 'business_id', 'id_business');
    }
}