<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class Invoice extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'invoice'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_invoice';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        
        'invoice_number',
        'invoice_day_seq',
        'invoice_date',
        'customer_id',
        'business_id',
        'customer_name',
        'customer_address',
        'customer_cell',
        'customer_email',
        'sub_total',
        'paid_amount',
        'returnamount',
        'discount',
        'gross_amount',
        'balance',
        'tax_total',
        'net_amount',
        'visit_id',
        'invoice_status',
        'invoice_type',
        'payment_mode',
        'instrument_number',
        'is_recovery',
        'reference_invoice_number',
        'paid_earlier',
        'remarks',
        'discount_remarks',
        'loyalty_used',
        'visit_time',
        'advance_amount',
        'other_charges',
        'advance_inst',
        'retained_used',
        'retained_amount',
        'retained_amount_used',
        'cctip',
        'sms_log',
        'loyalty_earned',
        'paid_cash',
        'paid_card',
        'paid_voucher',
        'paid_check',
        'paid_online',
        'paid_loyalty',
        'paid_retained',
        'cc_charge',
        'total_payable',
        'cancelreason',
        'created_by',
        'cancelled_by',
        'feedback_status',
        'invoice_seq',
        'discount_reason',
        'org_invoice_id',
        'service_addition',
        'imsfiscal_invoice_number',
        'gross_wo_tax',
        'order_id',
        'receipt_url',
        'receipt_code',
        'invoice_extra',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];


    public function business()
    {
        return $this->belongsTo(Business::class, 'business_id', 'id_business'); // assuming PK of business table is `id_business`
    }

    public function customers()
    {
        return $this->belongsTo(Customers::class, 'customer_id', 'id_customers'); // assuming PK of customers table is `id_customers`
    }
    
    public function customer_visits()
    {
        return $this->belongsTo(CustomerVisits::class, 'customer_visit_id', 'id_customer_visits'); // assuming PK of customer_visits table is `id_customer_visits`
    }



}
