<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class InvoiceDetails extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'invoice_details'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_invoice_details';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
       'id_invoice_details',
        'business_id',
        'invoice_id',
        'service_id',
        'service_type',
        'service_category',
        'service_name',
        'staff',
        'products',
        'price',
        'discount',
        'discount_type',
        'service_addition',
        'discounted_price',
        'invoice_discount',
        'final_price',
        'taxes',
        'paid',
        'invoice_detail_date',
        'detail_visit_date',
        'service_flag',
        'requested',
        'membership',
        'visit_service_id',
        'followupcall',
        'followupsms',

    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];


    public function invoice()
    {
        return $this->belongsTo(Invoice::class, 'invoice_id', 'id_invoice'); // assuming PK of invoice table is `id_invoice`
    }


}
