<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class InvoiceProducts extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'invoice_products'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_invoice_products';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
       
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];


    public function invoice()
    {
        return $this->belongsTo(Invoice::class, 'invoice_id', 'id_invoice'); // assuming PK of invoice table is `id_invoice`
    }

    public function products()
    {
        return $this->belongsTo(Products::class, 'product_id', 'id_business_products'); // assuming PK of business_products table is `id_business_products`
    }
}
