<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class InvoiceStaff extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'invoice_staff'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_invoice_staff';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
       
        'invoice_detail_id',
        'business_id',
        'invoice_id',
        'service_type',
        'service_category',
        'service_name',
        'staff_id',
        'staff_name',
        'price',
        'discount',
        'service_addition',
        'discounted_price',
        'invoice_discount',
        'final_price',
        'paid',
        'commission',
        'requested',
        'staff_share',
        'additional_staff',
        'visit_staff_id',

    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];


    public function invoice_details()
    {
        return $this->belongsTo(InvoiceDetails::class, 'invoice_detail_id', 'id_invoice_details'); // assuming PK of invoice_details table is `id_invoice_details`
    }

    public function staff()
    {
        return $this->belongsTo(Staff::class, 'staff_id', 'id_staff'); // assuming PK of Staff table is `id_staff`
    }
}
