<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class InvoiceVisitProducts extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'invoice_visit_products'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_invoice_visit_products';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
       'business_id',
       'invoice_id',
       'customer_visit_id',
       'service_id',
       'service_name',
       'product_id',
       'product_name',
       'product_qty',
       'product_unit'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];
    
    public function business()
    {
        return $this->belongsTo(Business::class, 'business_id', 'id_business'); 
    }

    
    public function invoice()
    {
        return $this->belongsTo(Invoice::class, 'invoice_id', 'id_invoice'); // assuming PK of invoice table is `id_invoice`
    }

    public function customer_visits()
    {
        return $this->belongsTo(CustomerVisits::class, 'customer_visit_id', 'id_customer_visits');
    }

    public function products()
    {
        return $this->belongsTo(Products::class, 'product_id', 'id_business_products'); // assuming PK of business_products table is `id_business_products`
    }
}
