<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class KitConfig extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'kit_config'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_kit_config';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'kit_id',
        'business_product_id',
        'kit_qty',
        'kit_config_date',
        'kit_created_by',
        'kit_measure_qty',
        'kit_product_cost',
        'kit_name',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];


    public function business_products()
    {
         return $this->belongsTo(Products::class, 'business_product_id', 'id_business_products');
    }

    public function product_kit()
    {
         return $this->belongsToMany(Products::class, 'kit_id', 'id_business_products');
    }
}
