<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LeavePolicy extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'leave_policies';
    protected $primaryKey = 'id_leave_policy';

    protected $fillable = [
        'policy_name',
        'policy_description',
        'business_id',
        'created_by',
        'created_at',
        'updated_at',
        'deleted_at'
    ];

    protected $dates = ['created_at', 'updated_at', 'deleted_at'];

    public function definitions()
    {
        return $this->hasMany(LeavePolicyDefinition::class, 'leave_policy_id', 'id_leave_policy');
    }
}