<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LeavePolicyDefinition extends Model
{
    use HasFactory;

    protected $table = 'leave_policies_definition';
    protected $primaryKey = 'id_leave_policy_def';

    protected $fillable = [
        'leave_policy_id',
        'leave_type_id',
        'leave_type',
        'allowed_count',
        'created_at'
    ];

    protected $dates = ['created_at'];

    public function leaveType()
    {
        return $this->belongsTo(LeaveType::class, 'leave_type_id', 'id_leave_type');
    }

    public function policy()
    {
        return $this->belongsTo(LeavePolicy::class, 'leave_policy_id', 'id_leave_policy');
    }
}
