<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LeaveType extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'leave_type';
    protected $primaryKey = 'id_leave_type';

    public $timestamps = false; 

    protected $fillable = [
        'leave_type',
        'created_by',
        'created_on',
        'status',
        'business_id'
    ];

    protected $dates = ['created_on', 'deleted_at'];

    // Add this casting
    protected $casts = [
        'created_on' => 'datetime',
    ];

    // Relationship with Business
    public function business()
    {
        return $this->belongsTo(Business::class, 'business_id', 'id_business');
    }

    // Scope for active leave types
    public function scopeActive($query)
    {
        return $query->where('status', 'Active');
    }

    // Scope for business filter
    public function scopeForBusiness($query, $businessId)
    {
        return $query->where('business_id', $businessId);
    }
}