<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class LoginLog extends Model
{
    use HasFactory;

    protected $table = 'login_logs';
    protected $primaryKey = 'id_login_log';

    protected $fillable = [
        'user_id',
        'user_name',
        'business_id',
        'ip_address',
        'user_agent',
        'login_time',
        'logout_time',
        'session_id',
    ];

    protected $casts = [
        'login_time' => 'datetime',
        'logout_time' => 'datetime',
    ];

    /**
     * Get the user that owns the login log.
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id_users');
    }

    /**
     * Get the business that the user logged into.
     */
    public function business()
    {
        return $this->belongsTo(Business::class, 'business_id', 'id_business');
    }
}
