<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class MappingFloor extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'mapping_floors';
    protected $primaryKey = 'id_mapping_floors';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'mapping_id',
        'business_floor_id',
        'active',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'active' => 'integer',
    ];

    public function categoryMapping()
    {
        return $this->belongsTo(CategoryMapping::class, 'mapping_id', 'id_mapping');
    }

    public function floor()
    {
        return $this->belongsTo(Floor::class, 'business_floor_id', 'id_business_floors');
    }
}

