<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;


class Menu extends Model
{
    use SoftDeletes;
    protected $table = 'menus'; 

    protected $guarded = ['id'];

    public function subMenu() 
    {
        return $this->hasMany(Menu::class, 'parent_id', 'id')->orderBy('sort_order', 'ASC');
    }
    
    public function subMenuActive() 
    {
        return $this->subMenu()->where('is_active', '1');
    }
    
    public function subMenuInactive() 
    {
        return $this->subMenu()->where('is_active', '0');
    }

    public function childs()
    {
        return $this->subMenu()->with('childs');
    }

    public function childsActive()
    {
        return $this->subMenuActive()->with('childsActive');
    }

    public function childsInactive()
    {
        return $this->subMenuInactive()->with('childsInactive');
    }

    public function parent()
    {
        return $this->belongsTo(Menu::class, 'parent_id', 'id');
    }
}
