<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class OrderProducts extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'order_products'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_order_products';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'business_id',
        'customer_order_id',
        'business_brand_id',
        'product_id',
        'product_name',
        'qty',
        'product_unit_price',
        'product_discount_amount',
        'product_sale_tax_percentage',
        'product_sale_tax_amount',
        'staff_id',
        'product_final_price',
        'staff_name',
        'category',
        'stockfrom',
        'batch',
        'batch_id'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];


    public function customer_orders()
    {
         return $this->belongsTo(CustomerOrders::class, 'customer_order_id', 'id_customer_order');
    }

    public function business_products()
    {
         return $this->belongsToMany(Products::class, 'product_id', 'id_business_products');
    }
}
