<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class OrderVouchers extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'order_vouchers'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_order_vouchers';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'business_id',
        'customer_id',
        'voucher_number',
        'voucher_heading',
        'type',
        'service_ids',
        'service_names',
        'amount',
        'voucher_date',
        'valid_until',
        'remaining_amount',
        'remaining_service_ids',
        'payment_mode',
        'instrument_number',
        'voucher_status',
        'paid_cash',
        'paid_card',
        'paid_check',
        'paid_voucher',
        'created_by',
        'voucher_tax',
        'voucher_cccharge',
        'voucher_value',
        'paid_online'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];


    public function business()
    {
        return $this->belongsTo(Business::class, 'business_id', 'id_business');
    }

   

}
