<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OvertimeDay extends Model
{
    use HasFactory;

    protected $table = 'overtime_days';
    
    // Disable automatic timestamps
    public $timestamps = false;
    
    protected $fillable = [
        'business_id',
        'overtime_reason',
        'overtime_day',
        'overtime_date',
        'created_by',
        'created_on'
    ];

    protected $casts = [
        'overtime_date' => 'date:Y-m-d', // Fixed: Format as Y-m-d without time
    ];
    
    // Set the primary key column
    protected $primaryKey = 'id_overtime';
    
    /**
     * Get the formatted overtime date (always Y-m-d)
     */
    public function getOvertimeDateAttribute($value)
    {
        if (!$value) {
            return null;
        }
        
        // If it's already a Carbon instance, format it
        if ($value instanceof \Carbon\Carbon) {
            return $value->format('Y-m-d');
        }
        
        // If it's a string, parse and format it
        return date('Y-m-d', strtotime($value));
    }
}