<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class PackageCategory extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'package_category'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_package_category';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'business_id',
        'package_type_id',
        'order_id',
        'service_category',        
        'service_category_active',
        'service_category_image',
        
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];


    public function package_type()
    {
        return $this->belongsTo(PackageType::class, 'package_type_id', 'id_package_type');
    }

    public function business()
    {
        return $this->belongsTo(Business::class, 'id_business', 'business_id');
    }

    public function business_services(){
         return $this->hasMany(Services::class, 'service_category_id', 'id_service_category');
    }

}
