<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class PackageServiceOptions extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'package_service_options'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_package_service_options';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
          'package_service_id',
          'service_id',
          'package_service_name',
          'package_service_rate',
          'package_service_qty'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];

    public function service()
    {
         return $this->belongsTo(Services::class, 'service_id', 'id_business_services');
    }

     public function package_services()
     {
           return $this->belongsTo(PackageServices::class, 'package_service_id', 'id_package_service');
     }
}
