<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class PackageServices extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'package_services'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_package_services';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
          'service_id',
          'package_category_id',
          'package_services_active',
          'service_rate',
          'package_service_optional',
          'package_option_number',
          'option_for',
          'package_service_qty'

    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];

    public function package_category()
    {
         return $this->belongsTo(PackageCategory::class, 'package_category_id', 'id_package_category');
    }

     public function services()
     {
           return $this->belongsTo(Services::class, 'service_id', 'id_business_services');
     }
}
