<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class PackageType extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'package_type'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_package_type';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
      
        'business_id',
        'order_id',
        'service_type',        
        'service_type_active',
        'service_type_image',
        'expiry_date',
        'business_type_id',
        
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];



    public function business()
    {
        return $this->belongsTo(Business::class, 'id_business', 'business_id');
    }

    public function package_category(){
         return $this->hasMany(PackageCategory::class, 'service_type_id');
    }

}
