<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class PermissionCategory extends Model
{
    protected $table = 'permission_categories';

    protected $fillable = [
        'name',
        'description',
        'sort_order',
    ];

    /**
     * Get all permissions in this category
     */
    public function permissions(): HasMany
    {
        return $this->hasMany(Permission::class, 'category_id');
    }
}
