<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class PricingBand extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'pricing_bands';
    protected $primaryKey = 'id_pricing_bands';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'mapping_id',
        'day',
        'timeslot_id',
        'min_percentage',
        'max_percentage',
        'discount_type',
        'discount',
        'active',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'min_percentage' => 'decimal:2',
        'max_percentage' => 'decimal:2',
        'discount' => 'decimal:2',
        'day' => 'integer',
        'active' => 'integer',
    ];

    public function categoryMapping()
    {
        return $this->belongsTo(CategoryMapping::class, 'mapping_id', 'id_mapping');
    }

    public function businessTimeslot()
    {
        return $this->belongsTo(BusinessTimeslot::class, 'timeslot_id', 'id_business_timeslots');
    }
}

