<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class ProductBatch extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'product_batch'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_batch';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'product_id',
        'batch_number',
        'batch_date',
        'expiry_date',
        'batch_qty',
        'store_id',
        'batch_amount',
        'batch_hidden'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];

    public function product()
    {
        return $this->belongsTo(Products::class, 'product_id', 'id_business_products'); 
    }

    public function batches()
    {
        return $this->belongsTo(ProductBatch::class, 'store_id', 'id_business_stores'); 
    }

}
