<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class Products extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'business_products'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_business_products';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'business_id',
        'brand_id',
        'product',
        'sku',
        'price',
        'purchase_price',
        'in_stock',
        'inhouse_stock',
        'unit_type',
        'measure_unit',
        'qty_per_unit',
        'business_product_active',
        'category',
        'professional',
        'opening_inhouse',
        'opening_instock',
        'opening_date',
        'product_threshold',
        'barcode_products',
        'commission',
        'product_type',
        'product_sales_tax',
        'track_inventory',
        'product_image',
        'commission_type',
        'updated_by',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];


    public function business()
    {
        return $this->belongsTo(Business::class, 'business_id', 'id_business'); // assuming PK of business table is `id_business`
    }

    public function invoice_products()
    {
        return $this->hasMany(InvoiceProducts::class, 'product_id', 'id_business_products'); 
    }

    public function brand()
    {
        return $this->belongsTo(Brands::class, 'brand_id', 'id_business_brands'); 
    }


}
