<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class PurchaseOrder extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'purchase_order'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'idpurchase_order';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
       'purchase_order_number',
        'business_id',
        'supplier_id',
        'supplier_name',
        'total_purchase_pirce',
        'status',           
        'product_total_qty',
        'order_date',
        'created_on',
        'created_by',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];

    function business()
    {
        return $this->belongsTo(Business::class, 'business_id', 'id_business');
    }

    function supplier()
    {
        return $this->belongsTo(Supplier::class, 'supplier_id', 'id_supplier');
    }

    function details()
    {
        return $this->hasMany(PurchaseOrderDetails::class, 'purchase_order_id', 'idpurchase_order');
    }

}
