<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class PurchaseOrderDetails extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'purchase_order_details'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'idpurchase_order_details';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
       'purchase_order_id',
        'brand_id',
        'product_id',
        'brand_name',
        'product_name',
        'product_purchase_price',
        'product_qty',
        'product_received_qty',
        'product_instock_qty',
        'product_inhouse_qty',
        'unit_discount',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];

    function purchaseOrder()
    {
        return $this->belongsTo(PurchaseOrders::class, 'purchase_order_id', 'idpurchase_order');
    }


}
