<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class Reports extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'reports'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_reports';


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
       'report_category_id',
       'report_name',
       'report_description',
       'report_file_path',
       'updated_at',
       'created_at',
       'last_viewed_by',
       'last_viewed_at'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];


}
