<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RestKey extends Model
{
    protected $table = 'rest_keys';
    protected $primaryKey = 'id';

    protected $fillable = [
        'user_id',
        'key',
        'level',
        'ignore_limits',
        'is_private_key',
        'ip_addresses',
        'date_created',
    ];

    protected $casts = [
        'ignore_limits' => 'boolean',
        'is_private_key' => 'boolean',
        'date_created' => 'integer',
    ];

    /**
     * Find a key by the API key value
     */
    public static function findByKey(string $key): ?self
    {
        return static::where('key', $key)->first();
    }

    /**
     * Check if the key is valid (not expired, etc.)
     * Add any additional validation logic here
     */
    public function isValid(): bool
    {
        // Add any validation logic if needed
        // For now, if the key exists, it's valid
        return true;
    }
}
