<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class ReturnNotes extends Model
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'return_notes'; // <-- this tells Laravel to use the correct table
    protected $primaryKey = 'id_return_notes'; // <-- this tells Laravel to use the correct primary key


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'return_date',
        'return_qty',
        'batch_id',
        'product_id',
        'user_id',
        'business_id',
        'return_status',
        'grn_id',

    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
       
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        
    ];

    public function grn()
    {
         return $this->belongsTo(GoodsReceivedNote::class, 'grn_id', 'grn_id');
    }
}
